package com.ejie.ab04b.dao;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.SituacionEntregaEnum;
import com.ejie.ab04b.dao.comun.UtilDAO;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.DatosEnvioPostal;
import com.ejie.ab04b.model.DatosLocalizacion;
import com.ejie.ab04b.model.DatosNotificacion;
import com.ejie.ab04b.model.OS2;
import com.ejie.ab04b.model.OS3;
import com.ejie.ab04b.model.Tramite;
import com.ejie.ab04b.model.Venviospostales;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/**
 * VenviospostalesDaoImpl generated by UDA, 07-ago-2017 13:35:26.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class VenviospostalesDaoImpl implements VenviospostalesDao {
	private JdbcTemplate jdbcTemplate;

	private static final String QUERY_SELECT = " SELECT TIPOEXP, "
			+ " ID_TRAMITE IDTRAMITE, TIPO_TRAMITE TIPOTRAMITE, TERRIT_APERTURA TERRITAPERTURA, ANO_APERTURA ANOAPERTURA, NUM_APERTURA NUMAPERTURA, FEC_REGISTRO FECREGISTRO, "
			+ " ID_DATOS_ENVIO_POSTAL_069 IDDATOSENVIOPOSTAL069, ID_REMESA_069 IDREMESA069, COD_REMESA_069 CODREMESA069, ID_COLECCION_069 IDCOLECCION069, COD_COLECCION_069 CODCOLECCION069, ID_ENVIO_069 IDENVIO069, COD_ENVIO_069 CODENVIO069, COD_SITUACION_ENVIO_069 CODSITUACIONENVIO069, DESC_SITUACION_ENVIO_ES_069 DESCSITUACIONENVIOES069, DESC_SITUACION_ENVIO_EU_069 DESCSITUACIONENVIOEU069, ESTADO_ENVIO_069 ESTADOENVIO069, FECNOTIFICACION_069 FECNOTIFICACION069, FEC_SITUACION_ENVIO_069 FECSITUACIONENVIO069, FECACUSE_069 FECACUSE069,ESTADOACUSE_069 ESTADOACUSE069, "
			+ " DESC_ESTADO_ENVIO_ES DESCESTADOENVIOES, DESC_ESTADO_ENVIO_EU DESCESTADOENVIOEU, "
			+ " ID_TRAMITE_089 IDTRAMITE089, DESCRIPCION_ES_089 DESCRIPCIONES089, DESCRIPCION_EU_089 DESCRIPCIONEU089, "
			+ " COD_DATOS_NOTIF_066 CODDATOSNOTIF066, "
			+ " COD_LOCALIZACION_067 CODLOCALIZACION067, DESC_PROVINCIA DESCPROVINCIA, DESC_MUNICIPIO DESCMUNICIPIO, DESC_LOCALIDAD DESCLOCALIDAD, CALLE_067 CALLE067, PORTAL_067 PORTAL067, CODPOSTAL_067 CODPOSTAL067, PISO_067 PISO067, PUERTA_067 PUERTA067, OID ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Venviospostales> rwMapEnviosPostales = new RowMapper<Venviospostales>() {
		public Venviospostales mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Venviospostales envioPostal = new Venviospostales();

			envioPostal.setTipoexp(resultSet.getString("TIPOEXP"));
			envioPostal.setIdTramite(resultSet.getLong("IDTRAMITE"));

			Tramite tramite = new Tramite(resultSet.getLong("IDTRAMITE089"));
			tramite.setDescripcionEs089(
					resultSet.getString("DESCRIPCIONES089"));
			tramite.setDescripcionEu089(
					resultSet.getString("DESCRIPCIONEU089"));
			envioPostal.setTramite(tramite);

			envioPostal
					.setTerritApertura(resultSet.getString("TERRITAPERTURA"));
			envioPostal.setAnoApertura(resultSet.getString("ANOAPERTURA"));
			envioPostal.setNumApertura(resultSet.getInt("NUMAPERTURA"));

			if (Constantes.OS2.equals(resultSet.getString("TIPOEXP"))) {
				OS2 os2 = new OS2(resultSet.getString("TERRITAPERTURA"),
						resultSet.getString("ANOAPERTURA"),
						resultSet.getInt("NUMAPERTURA"));
				envioPostal.setOs2(os2);
			} else if (Constantes.OS3.equals(resultSet.getString("TIPOEXP"))) {
				OS3 os3 = new OS3(resultSet.getString("TERRITAPERTURA"),
						resultSet.getString("ANOAPERTURA"),
						resultSet.getInt("NUMAPERTURA"));
				envioPostal.setOs3(os3);
			} else {
				ComunicacionApertura apertura = new ComunicacionApertura(
						resultSet.getString("TERRITAPERTURA"),
						resultSet.getString("ANOAPERTURA"),
						resultSet.getLong("NUMAPERTURA"));
				envioPostal.setApertura(apertura);
			}
			envioPostal.setFecRegistro(resultSet.getDate("FECREGISTRO"));

			DatosEnvioPostal datosEnvioPostal = new DatosEnvioPostal();

			if (resultSet.getInt("IDDATOSENVIOPOSTAL069") > 0) {
				datosEnvioPostal.setIdDatosEnvioPostal069(
						resultSet.getLong("IDDATOSENVIOPOSTAL069"));
			}
			if (resultSet.getInt("IDREMESA069") > 0) {
				datosEnvioPostal
						.setIdRemesa069(resultSet.getInt("IDREMESA069"));
			}
			if (UtilDAO.hasColumn(resultSet, "CODREMESA069")) {
				datosEnvioPostal
						.setCodRemesa069(resultSet.getString("CODREMESA069"));
			}
			if (resultSet.getInt("IDCOLECCION069") > 0) {
				datosEnvioPostal
						.setIdColeccion069(resultSet.getInt("IDCOLECCION069"));
			}
			if (resultSet.getInt("CODCOLECCION069") > 0) {
				datosEnvioPostal.setCodColeccion069(
						resultSet.getString("CODCOLECCION069"));
			}
			if (resultSet.getInt("IDENVIO069") > 0) {
				datosEnvioPostal.setIdEnvio069(resultSet.getInt("IDENVIO069"));
			}
			if (UtilDAO.hasColumn(resultSet, "CODENVIO069")) {
				datosEnvioPostal
						.setCodEnvio069(resultSet.getString("CODENVIO069"));
			}

			datosEnvioPostal.setCodSituacionEnvio069(
					resultSet.getString("CODSITUACIONENVIO069"));
			datosEnvioPostal.setDescSituacionEnvioEs069(
					resultSet.getString("DESCSITUACIONENVIOES069"));
			datosEnvioPostal.setDescSituacionEnvioEu069(
					resultSet.getString("DESCSITUACIONENVIOEU069"));
			datosEnvioPostal.setFecSituacionEnvio069(
					resultSet.getDate("FECSITUACIONENVIO069"));
			datosEnvioPostal
					.setEstadoEnvio069(resultSet.getString("ESTADOENVIO069"));
			datosEnvioPostal.setDescEstadoEnvioEs(
					resultSet.getString("DESCESTADOENVIOES"));
			datosEnvioPostal.setDescEstadoEnvioEu(
					resultSet.getString("DESCESTADOENVIOEU"));
			datosEnvioPostal.setFecnotificacion069(
					resultSet.getDate("FECNOTIFICACION069"));
			datosEnvioPostal.setFecAcuse069(resultSet.getDate("FECACUSE069"));
			datosEnvioPostal
					.setEstadoAcuse069(resultSet.getString("ESTADOACUSE069"));

			String descEstadoCodeEs = resultSet.getString("DESCESTADOENVIOES");
			String descEstadoCodeEu = resultSet.getString("DESCESTADOENVIOEU");

			datosEnvioPostal.setDescripcionEstadoEs(descEstadoCodeEs);
			datosEnvioPostal.setDescripcionEstadoEu(descEstadoCodeEu);

			envioPostal.setDatosEnvioPostal(datosEnvioPostal);

			envioPostal.setEsSituacionFinal(SituacionEntregaEnum
					.getByCodSituacion(
							datosEnvioPostal.getCodSituacionEnvio069())
					.esSituacionFinal());
			envioPostal.setEsEnvioCorrecto(SituacionEntregaEnum
					.getByCodSituacion(
							datosEnvioPostal.getCodSituacionEnvio069())
					.getEnvioCorrecto());

			DatosLocalizacion datosLoc = new DatosLocalizacion();
			datosLoc.setCodLocalizacion067(
					resultSet.getInt("CODLOCALIZACION067"));
			datosLoc.setCalle067(resultSet.getString("CALLE067"));
			datosLoc.setPortal067(resultSet.getString("PORTAL067"));
			datosLoc.setCodpostal067(resultSet.getString("CODPOSTAL067"));
			datosLoc.setPiso067(resultSet.getString("PISO067"));
			datosLoc.setPuerta067(resultSet.getString("PUERTA067"));

			DatosNotificacion datosNotif = new DatosNotificacion();

			datosNotif
					.setCodDatosNotif066(resultSet.getInt("CODDATOSNOTIF066"));
			datosNotif.setDatosLocalizacion(datosLoc);

			envioPostal.setDatosNotifEnvio(datosNotif);

			envioPostal.setDescProvincia(resultSet.getString("DESCPROVINCIA"));
			envioPostal.setDescMunicipio(resultSet.getString("DESCMUNICIPIO"));
			envioPostal.setDescLocalidad(resultSet.getString("DESCLOCALIDAD"));

			envioPostal.setOid(resultSet.getString("OID"));

			return envioPostal;
		}
	};

	private RowMapper<Venviospostales> rwMapPK = new RowMapper<Venviospostales>() {
		public Venviospostales mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Venviospostales venvioPostal = new Venviospostales();
			venvioPostal.setIdTramite(resultSet.getLong("IDTRAMITE"));

			return venvioPostal;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 *
	 * @param dataSource
	 *            the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds rows in the Venviospostales table using like.
	 * 
	 * venvioPostal Venviospostales List<Venviospostales>
	 *
	 * @param venvioPostal
	 *            the venvio postal
	 * @return the venviospostales
	 */
	@Transactional(readOnly = true)
	public Venviospostales find(Venviospostales venvioPostal) {
		StringBuilder query = new StringBuilder();
		query.append(VenviospostalesDaoImpl.QUERY_SELECT);
		query.append(" FROM VENVIOSPOSTALES ");
		query.append(" WHERE ID_TRAMITE = ? ");

		List<Venviospostales> listaResult = (List<Venviospostales>) this.jdbcTemplate
				.query(query.toString(), this.rwMapEnviosPostales,
						venvioPostal.getIdTramite());

		return (Venviospostales) DataAccessUtils.uniqueResult(listaResult);
	}

	/**
	 * Finds rows in the Venviospostales table using like.
	 * 
	 * venvioPostal Venviospostales List<Venviospostales>
	 *
	 * @param venvioPostal
	 *            the venvio postal
	 * @return the venviospostales
	 */
	@Transactional(readOnly = true)
	public Venviospostales findByTipoExp(Venviospostales venvioPostal) {
		StringBuilder query = new StringBuilder();
		query.append(VenviospostalesDaoImpl.QUERY_SELECT);
		query.append(" FROM VENVIOSPOSTALES ");
		query.append(" WHERE ID_TRAMITE = ? ");
		query.append(" AND TIPOEXP = ? ");

		List<Venviospostales> listaResult = (List<Venviospostales>) this.jdbcTemplate
				.query(query.toString(), this.rwMapEnviosPostales,
						venvioPostal.getIdTramite(), venvioPostal.getTipoexp());

		return (Venviospostales) DataAccessUtils.uniqueResult(listaResult);
	}

	/**
	 * Finds rows in the Venviospostales table using like.
	 * 
	 * venvioPostal Venviospostales jqGridRequestDto JQGridRequestDto List
	 * <Venviospostales>
	 *
	 * @param venvioPostal
	 *            the venvio postal
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Venviospostales> findEnvios(Venviospostales venvioPostal,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder();
		query.append(VenviospostalesDaoImpl.QUERY_SELECT);
		query.append(" FROM VENVIOSPOSTALES ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(venvioPostal);
		StringBuilder where = new StringBuilder(" WHERE 1=1  ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Venviospostales>) this.jdbcTemplate.query(query.toString(),
				this.rwMapEnviosPostales, params.toArray());
	}

	/**
	 * Finds rows in the Venviospostales table using like.
	 * 
	 * venvioPostal Venviospostales Long
	 *
	 * @param venvioPostal
	 *            the venvio postal
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findEnviosCount(Venviospostales venvioPostal) {
		StringBuilder query = new StringBuilder();
		query.append(" SELECT COUNT(1) ");
		query.append(" FROM VENVIOSPOSTALES ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(venvioPostal);
		StringBuilder where = new StringBuilder(" WHERE 1=1  ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Venviospostales selected for rup_table.
	 * 
	 * venvioPostal Venviospostales jqGridRequestDto JQGridRequestDto
	 * List<TableRowDto<Venviospostales>>
	 *
	 * @param venvioPostal
	 *            the venvio postal
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<Venviospostales>> reorderSelection(
			Venviospostales venvioPostal, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder();
		query.append(VenviospostalesDaoImpl.QUERY_SELECT);

		// FROM
		query.append(" FROM VENVIOSPOSTALES ");
		// FILTRADO

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(venvioPostal);
		StringBuilder where = new StringBuilder(" WHERE 1=1  ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Venviospostales.class, filterParamList,
				"IDTRAMITE");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<Venviospostales>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TramiteAperturas entity.
	 * 
	 * venvioPostal Venviospostales Bean with the criteria values to filter by.
	 * Map created with two keys key query stores the sql query syntax key
	 * params stores the parameter values to be used in the condition sentence.
	 *
	 * @param venvioPostal
	 *            the venvio postal
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Venviospostales venvioPostal) {

		StringBuilder where = new StringBuilder(
				VenviospostalesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (venvioPostal != null && venvioPostal.getIdTramite() != null) {
			where.append(" AND ID_TRAMITE = ?");
			params.add(venvioPostal.getIdTramite());
		}
		if (venvioPostal != null && venvioPostal.getTipoTramite() != null
				&& venvioPostal.getTramite().getIdTramite089() != null) {
			where.append(" AND TIPO_TRAMITE = ?");
			params.add(venvioPostal.getTramite().getIdTramite089());
		}

		if (venvioPostal != null && venvioPostal.getTerritApertura() != null) {
			where.append(" AND TERRIT_APERTURA = ?");
			params.add(venvioPostal.getTerritApertura());
		}
		if (venvioPostal != null && venvioPostal.getAnoApertura() != null) {
			where.append(" AND ANO_APERTURA = ?");
			params.add(venvioPostal.getAnoApertura());
		}
		if (venvioPostal != null && venvioPostal.getNumApertura() != null) {
			where.append(" AND NUM_APERTURA = ?");
			params.add(venvioPostal.getNumApertura());
		}

		if (venvioPostal != null
				&& venvioPostal.getFecRegistroDesde() != null) {
			where.append(" AND FEC_REGISTRO >= ?");
			params.add(venvioPostal.getFecRegistroDesde());
		}
		if (venvioPostal != null
				&& venvioPostal.getFecRegistroHasta() != null) {
			where.append(" AND FEC_REGISTRO <= (? + 1)");
			params.add(venvioPostal.getFecRegistroHasta());
		}
		if (venvioPostal.getDatosEnvioPostal() != null) {
			if (venvioPostal != null && venvioPostal.getDatosEnvioPostal()
					.getCodRemesa069() != null) {
				where.append(" AND UPPER(COD_REMESA_069) = ?");
				params.add(venvioPostal.getDatosEnvioPostal().getCodRemesa069()
						.toUpperCase());
			}
			if (venvioPostal != null && venvioPostal.getDatosEnvioPostal()
					.getCodColeccion069() != null) {
				where.append(" AND COD_COLECCION_069 = ?");
				params.add(venvioPostal.getDatosEnvioPostal()
						.getCodColeccion069());
			}
			if (venvioPostal != null && venvioPostal.getDatosEnvioPostal()
					.getCodEnvio069() != null) {
				where.append(" AND COD_ENVIO_069 = ?");
				params.add(venvioPostal.getDatosEnvioPostal().getCodEnvio069());
			}
		}
		if (venvioPostal != null
				&& venvioPostal.getEstadosComunicaciones() != null
				&& venvioPostal.getEstadosComunicaciones().length > 0) {
			StringBuilder queryIn = new StringBuilder();
			for (int i = 0; i < venvioPostal
					.getEstadosComunicaciones().length; i++) {
				queryIn.append(",?");
			}
			queryIn.deleteCharAt(0);
			where.append(" AND ESTADO_ENVIO_069 IN (");
			where.append(queryIn);
			where.append(") ");
			params.addAll(
					Arrays.asList(venvioPostal.getEstadosComunicaciones()));
		}

		if (venvioPostal != null && venvioPostal.getTiposexp() != null
				&& venvioPostal.getTiposexp().length > 0) {
			StringBuilder queryIn = new StringBuilder();
			for (int i = 0; i < venvioPostal.getTiposexp().length; i++) {
				queryIn.append(",?");
			}
			queryIn.deleteCharAt(0);
			where.append(" AND TIPOEXP IN (");
			where.append(queryIn);
			where.append(") ");
			params.addAll(Arrays.asList(venvioPostal.getTiposexp()));
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
